/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.parser;

import com.ibm.hwmca.fw.servlet.pmod.ModelConstants;
import com.ibm.hwmca.fw.servlet.pmod.ModelContentHandler;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.ModelResources;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.MalformedNodeException;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParser;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParserException;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParserSource;
import com.ibm.hwmca.fw.util.FastStack;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ModelParserImpl
implements ModelParser,
ModelConstants {
    public static final String TRACE_MASK = "XPMPMPI";
    private static final boolean DEBUG = false;
    private static final char MARKER_NOT_QUOTE = ' ';
    private static final char[] PATTREN_XML = new char[]{'x', 'm', 'l'};
    private static final char[] PATTREN_DOCTYPE = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] PATTREN_CDATA = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] PATTREN_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] PATTREN_END_SCRIPT = new char[]{'/', 's', 'c', 'r', 'i', 'p', 't'};
    private static final char[] PATTREN_DASHDASH = new char[]{'-', '-'};
    private static final char[] PATTREN_END_XML_DECL = new char[]{'?', '>'};
    private static final char[] PATTREN_END_CDATA = new char[]{']', ']', '>'};
    private static final char[] PATTREN_END_XML_COMMENT = new char[]{'-', '-', '>'};
    private static final char[] PATTREN_END_JSP_COMMENT = new char[]{'-', '-', '%', '>'};
    private static final char[] PATTREN_END_JSP_PAGEDIR = new char[]{'%', '>'};
    private static final char[] PATTREN_END_JSP_EL_EXPR = new char[]{'}'};
    private static final char[] PATTREN_END_EMPTYTAG = new char[]{'/', '>'};
    private static final char[] PATTREN_CONSTRUCT_START = new char[]{'<', '$'};
    private static final char[] PATTREN_SINGLE_QUOTED_ATTRIB = new char[]{'\\', '\'', '$'};
    private static final char[] PATTREN_DOUBLE_QUOTED_ATTRIB = new char[]{'\\', '\"', '$'};
    private static final char[] PATTREN_INTRA_EL_EXPR_CHARS = new char[]{'\\', '}', '\"', '\''};
    private static final char[] PATTREN_NEXT_TOKEN_DELIMS = new char[]{' ', '/', '>', '\n', '\r', '\t', '\f'};
    private static final char[] PATTREN_GENERAL_TAG_END = new char[]{'>'};
    private static char[][] validNamespaces = null;
    private ModelContentHandler handler;
    private FastStack tagStack = new FastStack();
    private ModelParserSource input = null;
    private int start = 0;
    private int end = 0;
    private boolean scriptMode = false;

    public static String decodeQuotes(char[] buffer, int start, int end) {
        StringBuffer sb = null;
        int unHarvested = start;
        for (int i = start; i <= end; ++i) {
            if (i >= buffer.length || buffer[i] != '\\' || i + 1 >= buffer.length || buffer[i + 1] != '\"') continue;
            if (sb == null) {
                sb = new StringBuffer(65);
            }
            sb.append(buffer, unHarvested, i - unHarvested);
            unHarvested = i + 1;
        }
        if (sb == null) {
            return new String(buffer, start, end - start);
        }
        if (end - unHarvested > 0) {
            sb.append(buffer, unHarvested, end - unHarvested);
        }
        return sb.toString();
    }

    public static String decodeQuotes(String raw) {
        if (raw.indexOf(92) > 0) {
            char[] buffer = new char[raw.length()];
            raw.getChars(0, buffer.length, buffer, 0);
            return ModelParserImpl.decodeQuotes(buffer, 0, buffer.length);
        }
        return raw;
    }

    public void setHandler(ModelContentHandler handler) {
        this.handler = handler;
    }

    public void parse(ModelParserSource input) {
        if (this.handler == null) {
            throw new RuntimeException("No handler set in parser impl");
        }
        try {
            this.handler.startDocument();
            boolean done = false;
            this.input = input;
            this.start = input.mark();
            block13: while (!done) {
                this.end = input.seekToAny(PATTREN_CONSTRUCT_START);
                if (this.end != -1) {
                    switch (input.getChar()) {
                        case '<': {
                            switch (input.peekChar()) {
                                case '?': {
                                    if (this.scriptMode) continue block13;
                                    input.adjustCursor(1);
                                    if (input.ifNextConsume(PATTREN_XML)) {
                                        this.processIgnoredConstruct("<?xml", "?>", PATTREN_END_XML_DECL);
                                        continue block13;
                                    }
                                    throw new ModelParserException("'<?' found in inappropriate context.  " + input.currentLocation());
                                }
                                case '!': {
                                    if (this.scriptMode) continue block13;
                                    input.adjustCursor(1);
                                    if (input.ifNextConsume(PATTREN_DOCTYPE)) {
                                        this.processIgnoredConstruct("<!DOCTYPE", ">", PATTREN_GENERAL_TAG_END);
                                        continue block13;
                                    }
                                    if (input.ifNextConsume(PATTREN_DASHDASH)) {
                                        this.processIgnoredConstruct("<!--", "-->", PATTREN_END_XML_COMMENT);
                                        continue block13;
                                    }
                                    if (input.ifNextConsume(PATTREN_CDATA)) {
                                        this.processIgnoredConstruct("<![CDATA[", "]]>", PATTREN_END_CDATA);
                                        continue block13;
                                    }
                                    throw new ModelParserException("'<!' found in inappropriate context.  " + input.currentLocation());
                                }
                                case '%': {
                                    input.adjustCursor(1);
                                    if (this.scriptMode) {
                                        if (!input.ifNextConsume(PATTREN_DASHDASH)) continue block13;
                                        this.processIgnoredConstruct("<%--", "--%>", PATTREN_END_JSP_COMMENT);
                                        continue block13;
                                    }
                                    if (input.ifNextConsume(PATTREN_DASHDASH)) {
                                        this.processIgnoredConstruct("<%--", "--%>", PATTREN_END_JSP_COMMENT);
                                        continue block13;
                                    }
                                    if (input.ifNextConsume('@')) {
                                        this.processJSPDirective();
                                        continue block13;
                                    }
                                    if (input.ifNextConsume('!')) {
                                        throw new ModelParserException("JSP declaration is not supported.  " + input.currentLocation());
                                    }
                                    if (input.ifNextConsume('=')) {
                                        throw new ModelParserException("JSP expression is not supported.  " + input.currentLocation());
                                    }
                                    throw new ModelParserException("JSP scriptlet is not supported.  " + input.currentLocation());
                                }
                            }
                            if (input.ifNext(PATTREN_SCRIPT)) {
                                this.scriptMode = true;
                                this.processStandardTag();
                                continue block13;
                            }
                            if (input.ifNext(PATTREN_END_SCRIPT)) {
                                this.scriptMode = false;
                                this.processStandardTag();
                                continue block13;
                            }
                            if (this.scriptMode) {
                                for (int i = 0; i < validNamespaces.length; ++i) {
                                    if (!input.ifNext(validNamespaces[i])) continue;
                                    this.processStandardTag();
                                    continue block13;
                                }
                                continue block13;
                            }
                            this.processStandardTag();
                            continue block13;
                        }
                        case '$': {
                            if (!input.ifNextConsume('{')) continue block13;
                            input.adjustCursor(-2);
                            this.processELExpression();
                            continue block13;
                        }
                    }
                    throw new ModelParserException("Internal error, not '<' or '$'... " + input.currentLocation());
                }
                done = true;
                char[] buffer = input.getBuffer();
                int length = buffer.length - this.start;
                if (length <= 0) continue;
                this.handler.characters(input.getBuffer(), this.start, length);
            }
            this.handler.endDocument();
        }
        catch (PanelModelException e) {
            this.handler.error(e, input != null ? input.currentLocation() : "");
        }
        catch (MalformedNodeException e) {
            String location = input != null ? input.currentLocation() : null;
            ModelParserException exception = new ModelParserException("Malformed node exception during parser processing loop. (" + (location != null ? location : "Location unavailable") + ")");
            exception.initCause(e);
            this.handler.error(exception, location != null ? location : "");
        }
        catch (Exception e) {
            String location = input != null ? input.currentLocation() : null;
            ModelParserException exception = new ModelParserException("Exception during parser processing loop. (" + (location != null ? location : "Location unavailable") + ")");
            exception.initCause(e);
            this.handler.error(exception, location != null ? location : "");
        }
    }

    private void processELExpression() throws PanelModelException {
        int length = this.end - this.start;
        if (length > 0) {
            this.handler.characters(this.input.getBuffer(), this.start, length);
        }
        this.start = this.input.mark();
        this.end = this.findElExpressionEnd();
        if (this.end == -1) {
            throw new ModelParserException("JSP ELExpression unterminated.  " + this.input.currentLocation());
        }
        length = this.end - this.start + 1;
        if (length > 0) {
            this.handler.jspELExpression(this.input.getBuffer(), this.start, length);
        }
        this.start = this.input.mark() + 1;
    }

    private void processJSPDirective() throws PanelModelException {
        this.input.adjustCursor(-3);
        int length = this.end - this.start;
        if (length > 0) {
            this.handler.characters(this.input.getBuffer(), this.start, length);
        }
        this.start = this.input.mark();
        this.end = this.input.seekTo(PATTREN_END_JSP_PAGEDIR);
        if (this.end == -1) {
            throw new ModelParserException("Unbalanced, unable to locate '%>' terminating a JSP Directive construct.");
        }
        length = this.end - this.start + 2;
        if (length > 0) {
            this.handler.jspDirective(this.input.getBuffer(), this.start, length);
        }
        this.start = this.input.mark() + 2;
    }

    private void processStandardTag() throws PanelModelException {
        String rawTagName;
        int length = this.end - this.start;
        if (length > 0) {
            this.handler.characters(this.input.getBuffer(), this.start, length);
        }
        boolean endTagOnly = false;
        if (this.input.peekChar() == '/') {
            endTagOnly = true;
            this.input.adjustCursor(1);
        }
        String tagName = rawTagName = this.input.nextToken(PATTREN_NEXT_TOKEN_DELIMS);
        String prefixName = "";
        int colonIndex = tagName.indexOf(":");
        if (colonIndex != -1) {
            prefixName = tagName.substring(0, colonIndex);
            tagName = tagName.substring(colonIndex + 1);
        }
        if (endTagOnly) {
            String endTag = (String)this.tagStack.pop();
            if (!rawTagName.equals(endTag)) {
                throw new ModelParserException("End tag mismatch.  Expected '" + endTag + "' but found '" + rawTagName + "'.  " + this.input.currentLocation());
            }
            this.handler.endElement(prefixName, tagName);
            if (this.input.seekTo('>') == -1) {
                throw new ModelParserException("Incomplete end tag?.  " + this.input.currentLocation());
            }
            this.input.adjustCursor(1);
        } else {
            this.handler.startElement(prefixName, tagName, this.parseTagAttributes(), false);
            if (this.input.ifNextConsume(PATTREN_END_EMPTYTAG)) {
                this.handler.endElement(prefixName, tagName);
            } else if (this.input.ifNextConsume('>')) {
                this.tagStack.push(rawTagName);
            } else {
                throw new ModelParserException("Internal error, expected '>'.  " + this.input.currentLocation());
            }
        }
        this.start = this.input.mark();
    }

    private Properties parseTagAttributes() throws PanelModelException {
        Properties attributes = ModelConstants.PM_EMPTY_PROPERTIES;
        String name = this.parseName();
        while (name != null) {
            if (attributes.containsKey(name)) {
                throw new ModelParserException("Duplicate specification of attribute name '" + name + "'.  " + this.input.currentLocation());
            }
            this.input.skipWhitespace();
            if (!this.input.ifNextConsume('=')) {
                throw new ModelParserException("No equal sign following attribute " + name + " " + this.input.currentLocation());
            }
            this.input.skipWhitespace();
            char quote = this.input.getChar();
            if (quote != '\'' && quote != '\"') {
                throw new ModelParserException("No quote on attribute value.  " + this.input.currentLocation());
            }
            if (attributes instanceof ModelConstants.PmEmptyProperties) {
                attributes = new Properties();
            }
            String value = this.parseAttributeValue(quote);
            attributes.put(name, value);
            name = this.parseName();
        }
        return attributes;
    }

    private String parseName() throws PanelModelException {
        this.input.skipWhitespace();
        char ch = this.input.peekChar();
        if (Character.isLetter(ch) || ch == '_' || ch == ':') {
            StringBuffer buf = new StringBuffer();
            buf.append(ch);
            this.input.getChar();
            ch = this.input.peekChar();
            while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '_' || ch == '-' || ch == ':') {
                buf.append(ch);
                this.input.getChar();
                ch = this.input.peekChar();
            }
            return buf.toString();
        }
        return null;
    }

    private String parseAttributeValue(char watch) throws PanelModelException {
        int start = this.input.mark();
        int end = -1;
        char[] pattren = watch == '\"' ? PATTREN_DOUBLE_QUOTED_ATTRIB : PATTREN_SINGLE_QUOTED_ATTRIB;
        boolean done = false;
        block4: while (!done) {
            end = this.input.seekToAny(pattren);
            if (end == -1) {
                throw new ModelParserException("No ending quote on attribute.  " + this.input.currentLocation());
            }
            char tripper = this.input.getChar();
            switch (tripper) {
                case '\\': {
                    this.input.adjustCursor(1);
                    continue block4;
                }
                case '$': {
                    if (this.input.ifNextConsume('{') && (end = this.findElExpressionEnd()) == -1) {
                        throw new ModelParserException("Unterminated ELExpression in attribute.  " + this.input.currentLocation());
                    }
                    this.input.adjustCursor(1);
                    continue block4;
                }
            }
            done = true;
        }
        return ModelParserImpl.decodeQuotes(this.input.getBuffer(), start, end);
    }

    private int findElExpressionEnd() {
        boolean done = false;
        int quote = 32;
        while (!done) {
            if (this.input.seekToAny(PATTREN_INTRA_EL_EXPR_CHARS) != -1) {
                int current = this.input.peekChar();
                switch (current) {
                    case 125: {
                        done = quote == 32;
                        break;
                    }
                    case 92: {
                        this.input.adjustCursor(2);
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (quote != 32 && quote == current) {
                            quote = 32;
                            this.input.adjustCursor(1);
                            break;
                        }
                        quote = this.input.getChar();
                    }
                }
                continue;
            }
            return -1;
        }
        return this.input.mark();
    }

    private void processIgnoredConstruct(String prefix, String suffix, char[] pattren) throws PanelModelException {
        int length = this.end - this.start;
        if (length > 0) {
            this.handler.characters(this.input.getBuffer(), this.start, length);
        }
        this.handler.startIgnoredConstruct(prefix);
        int piCstart = this.input.mark();
        int piCend = this.input.seekTo(pattren);
        if (piCend == -1) {
            throw new ModelParserException("Unbalanced, unable to locate " + new String(pattren) + " construct.");
        }
        length = piCend - piCstart;
        if (length > 0) {
            this.handler.characters(this.input.getBuffer(), piCstart, length);
        }
        this.input.adjustCursor(pattren.length);
        this.handler.endIgnoredConstruct(suffix);
        this.start = this.input.mark();
    }

    static {
        try {
            ResourceBundle rb = ModelResources.getModelResources();
            boolean done = false;
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements() && !done) {
                String key = e.nextElement();
                if (!"valid.tag.namespaces".equals(key)) continue;
                String nameSpaces = rb.getString(key);
                done = true;
                StringTokenizer st = new StringTokenizer(nameSpaces);
                validNamespaces = new char[st.countTokens() * 2][];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String ns = st.nextToken().concat(":");
                    ModelParserImpl.validNamespaces[i] = new char[ns.length()];
                    ns.getChars(0, validNamespaces[i].length, validNamespaces[i], 0);
                    ns = "/".concat(ns);
                    ModelParserImpl.validNamespaces[++i] = new char[ns.length()];
                    ns.getChars(0, validNamespaces[i].length, validNamespaces[i], 0);
                    ++i;
                }
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }
}

